#ifndef __BTHSDPDEF_H__
#pragma option push -b -a8 -pc -A- /*P_O_Push*/
#define __BTHSDPDEF_H__

#ifdef __cplusplus
extern "C" {
#endif

struct SDP_LARGE_INTEGER_16 {
    ULONGLONG LowPart;
    LONGLONG HighPart;
}; 
 

struct SDP_ULARGE_INTEGER_16 {
    ULONGLONG LowPart;
    ULONGLONG HighPart;
};

typedef struct SDP_ULARGE_INTEGER_16 SDP_ULARGE_INTEGER_16, *PSDP_ULARGE_INTEGER_16, *LPSDP_ULARGE_INTEGER_16;
typedef struct SDP_LARGE_INTEGER_16  SDP_LARGE_INTEGER_16,  *PSDP_LARGE_INTEGER_16,  *LPSDP_LARGE_INTEGER_16;

enum NodeContainerType {
	NodeContainerTypeSequence,
    NodeContainerTypeAlternative
};

typedef enum NodeContainerType NodeContainerType;

typedef USHORT SDP_ERROR, *PSDP_ERROR;

enum SDP_TYPE {
    SDP_TYPE_NIL =  0x00,
    SDP_TYPE_UINT = 0x01,
    SDP_TYPE_INT = 0x02,
    SDP_TYPE_UUID = 0x03,
    SDP_TYPE_STRING = 0x04,
    SDP_TYPE_BOOLEAN = 0x05,
    SDP_TYPE_SEQUENCE = 0x06,
    SDP_TYPE_ALTERNATIVE = 0x07,
    SDP_TYPE_URL = 0x08,
    SDP_TYPE_CONTAINER = 0x20
};
//  9 - 31 are reserved
typedef enum SDP_TYPE SDP_TYPE;

// allow for a little easier type checking / sizing for integers and UUIDs
// ((SDP_ST_XXX & 0xF0) >> 4) == SDP_TYPE_XXX
// size of the data (in bytes) is encoded as ((SDP_ST_XXX & 0xF0) >> 8)
enum SDP_SPECIFICTYPE {
    SDP_ST_NONE = 0x0000,

    SDP_ST_UINT8 = 0x0010,
    SDP_ST_UINT16 = 0x0110,
    SDP_ST_UINT32 = 0x0210,
    SDP_ST_UINT64 = 0x0310,
    SDP_ST_UINT128 = 0x0410,
    
    SDP_ST_INT8 = 0x0020,
    SDP_ST_INT16 = 0x0120,
    SDP_ST_INT32 = 0x0220,
    SDP_ST_INT64 = 0x0320,
    SDP_ST_INT128 = 0x0420,
    
    SDP_ST_UUID16 = 0x0130,
    SDP_ST_UUID32 = 0x0220,
    SDP_ST_UUID128 = 0x0430
};
typedef enum SDP_SPECIFICTYPE SDP_SPECIFICTYPE;

typedef struct _SdpAttributeRange {
    USHORT minAttribute;
    USHORT maxAttribute;
} SdpAttributeRange;


typedef
#ifdef USE_MIDL_SYNTAX 
      [switch_type(unsigned short)]
#endif
                                    union SdpQueryUuidUnion {
#ifdef USE_MIDL_SYNTAX 
    [case(SDP_ST_UUID128)]
#endif
       GUID uuid128;

#ifdef USE_MIDL_SYNTAX 
    [case(SDP_ST_UUID32)] 
#endif _NTDDK_
       ULONG uuid32;

#ifdef USE_MIDL_SYNTAX 
    [case(SDP_ST_UUID16)]
#endif _NTDDK_
        USHORT uuid16;
} SdpQueryUuidUnion;

typedef struct _SdpQueryUuid {
#ifdef USE_MIDL_SYNTAX 
    [switch_is(uuidType)]
#endif
       SdpQueryUuidUnion u;

    USHORT uuidType;
} SdpQueryUuid;


#ifdef __cplusplus
};
#endif


#pragma option pop /*P_O_Pop*/
#endif // __BTHSDPDEF_H__
